' VB Script to verify the presence of Exchange 2000 and a given organization    '
'                                                                               '
' Version 1.00 - Alain Lissoir                                                  '
' Compaq Computer Corporation - Professional Services - Belgium -               '
'                                                                               '
' Any comments or questions:                     EMail:alain.lissoir@compaq.com '

Option Explicit

' ------------------------------------------------------------------------------------------------------------------------
Private Function VerifyExchangeOrg (strExchangeOrganization)

Dim objRoot
Dim strConfigNC
Dim objExchangeContainer
Dim objExchangeChild

        Set ObjRoot = GetObject("LDAP://RootDSE")
        strConfigNC = ObjRoot.Get("configurationNamingContext")
        WScript.DisconnectObject ObjRoot
        Set ObjRoot = Nothing

        On Error Resume Next
        Set objExchangeContainer = GetObject ("LDAP://CN=Microsoft Exchange,CN=Services," & _
                                             strConfigNC)
        If Err.Number Then
           ' Exchange container in services not present, Exchange 2000 is not installed
           VerifyExchangeOrg = False
           Exit Function
        End If

        For Each objExchangeChild In objExchangeContainer
            If (objExchangeChild.Class = "msExchOrganizationContainer") And _
               (objExchangeChild.Get ("cn") = strExchangeOrganization) Then
                  Wscript.Echo "Found Exchange Organization called '" & _
                               objExchangeChild.Get ("cn") & "'."
                  Wscript.Echo
                  VerifyExchangeOrg = True
                  Exit Function
            End If
        Next

        VerifyExchangeOrg = False

End Function